/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityfolder;

import com.quantumdata.sct.dao.impl.DeviceModelDAO;
import com.quantumdata.sct.dao.impl.DeviceTypeDAO;
import com.quantumdata.sct.dao.impl.ModelCapabilityDAO;
import com.quantumdata.sct.dao.impl.ModelDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.DeviceModelVO;
import com.quantumdata.sct.dao.vo.DeviceTypeVO;
import com.quantumdata.sct.dao.vo.ModelVO;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.activityarea.ToolsActivityArea;
import com.quantumdata.sct.gui.activityarea.UnitSelectActivityArea;
import com.quantumdata.sct.gui.activityfolder.ActivityFolder;
import com.quantumdata.sct.gui.activityfolder.CreateNewModel;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTComboBox;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.wizard.IBOHandler;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class ModelSelectionFolder
extends ActivityFolder
implements ActionListener,
IBOHandler {
    private SCTComboBox mftComboBox;
    private SCTComboBox devicetypeComboBox;
    private JList modelList;
    private SCTButton selectModelBtn;
    private SCTButton createModelBtn;
    private SCTButton deleteModelBtn;
    private Vector models = new Vector();
    private ComplianceTesterToolUI m_toolUI;

    public ModelSelectionFolder(ComplianceTesterToolUI complianceTesterToolUI) {
        super(complianceTesterToolUI, "CDF Selection");
        this.m_toolUI = complianceTesterToolUI;
        this.init();
        this.populateUI();
    }

    private void init() {
        SCTPanel sCTPanel = new SCTPanel();
        BoxLayout boxLayout = new BoxLayout(sCTPanel, 0);
        sCTPanel.setLayout(boxLayout);
        sCTPanel.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 1, 1);
        gridBagConstraints2.insets = new Insets(0, 5, 1, 1);
        SCTPanel sCTPanel2 = new SCTPanel(gridBagLayout);
        SCTPanel sCTPanel3 = new SCTPanel(gridBagLayout);
        SCTLabel sCTLabel = new SCTLabel("Filter by Product");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(sCTLabel, gridBagConstraints);
        sCTPanel2.add(sCTLabel);
        this.devicetypeComboBox = new SCTComboBox();
        this.devicetypeComboBox.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.devicetypeComboBox, gridBagConstraints);
        sCTPanel2.add(this.devicetypeComboBox);
        SCTLabel sCTLabel2 = new SCTLabel("Filter by Manufacturer");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(sCTLabel2, gridBagConstraints);
        sCTPanel2.add(sCTLabel2);
        this.mftComboBox = new SCTComboBox();
        this.mftComboBox.addActionListener(this);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.mftComboBox, gridBagConstraints);
        sCTPanel2.add(this.mftComboBox);
        SCTLabel sCTLabel3 = new SCTLabel("Select CDF");
        gridBagConstraints2.gridwidth = 0;
        gridBagLayout.setConstraints(sCTLabel3, gridBagConstraints2);
        sCTPanel3.add(sCTLabel3);
        this.modelList = new JList(this.getAllModels());
        this.modelList.setFont(SCTConstants.SS_B_14);
        JScrollPane jScrollPane = new JScrollPane(this.modelList, 22, 31);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.insets = new Insets(2, 5, 2, 25);
        gridBagConstraints3.ipadx = 10;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 4;
        jScrollPane.setMinimumSize(new Dimension(400, 220));
        jScrollPane.setMaximumSize(new Dimension(400, 220));
        jScrollPane.setPreferredSize(new Dimension(400, 220));
        sCTPanel3.add((Component)jScrollPane, gridBagConstraints3);
        this.selectModelBtn = new SCTButton("Select");
        this.selectModelBtn.addActionListener(this);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(2, 5, 2, 25);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 5;
        sCTPanel3.add((Component)this.selectModelBtn, gridBagConstraints4);
        this.createModelBtn = new SCTButton("Duplicate As");
        this.createModelBtn.addActionListener(this);
        gridBagConstraints4.gridy = 6;
        sCTPanel3.add((Component)this.createModelBtn, gridBagConstraints4);
        this.deleteModelBtn = new SCTButton("Delete");
        this.deleteModelBtn.addActionListener(this);
        gridBagConstraints4.gridy = 7;
        sCTPanel3.add((Component)this.deleteModelBtn, gridBagConstraints4);
        sCTPanel.add(sCTPanel2);
        sCTPanel.add(sCTPanel3);
        this.add(sCTPanel);
    }

    private void populateUI() {
        this.populateManufacturerComboBox();
        this.populateDeviceTypeComboBox();
        this.filterModels(this.getAllModels());
        this.modelList.updateUI();
    }

    private void populateManufacturerComboBox() {
        this.mftComboBox.removeAllItems();
        this.mftComboBox.addItem("Select one..");
        ModelDAO modelDAO = null;
        IPersistable[] iPersistableArray = null;
        try {
            int n;
            modelDAO = (ModelDAO)XMLDAOFactory.getModelDAO();
            iPersistableArray = modelDAO.findByAll();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < iPersistableArray.length; ++i) {
                ModelVO modelVO = (ModelVO)iPersistableArray[i];
                vector.add(modelVO.getManufacturer());
            }
            Vector vector2 = new Vector();
            for (n = 0; n < vector.size(); ++n) {
                if (vector2.contains(vector.get(n))) continue;
                vector2.addElement(vector.get(n));
            }
            for (n = 0; n < vector2.size(); ++n) {
                this.mftComboBox.addItem(vector2.elementAt(n));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void populateDeviceTypeComboBox() {
        this.devicetypeComboBox.removeAllItems();
        this.devicetypeComboBox.addItem("Select one..");
        DeviceTypeDAO deviceTypeDAO = null;
        IPersistable[] iPersistableArray = null;
        String string = SCTSelection.instance().getDeviceID();
        int n = 0;
        try {
            deviceTypeDAO = (DeviceTypeDAO)XMLDAOFactory.getDeviceTypeDAO();
            iPersistableArray = deviceTypeDAO.findByAll();
            for (int i = 0; i < iPersistableArray.length; ++i) {
                DeviceTypeVO deviceTypeVO = (DeviceTypeVO)iPersistableArray[i];
                this.devicetypeComboBox.addItem(deviceTypeVO);
                if (string == null || !string.equals(deviceTypeVO.getId())) continue;
                n = i + 1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.devicetypeComboBox.setSelectedIndex(n);
    }

    public void setDeviceTypeComboBox(DeviceTypeVO deviceTypeVO) {
        for (int i = 0; i < this.devicetypeComboBox.getItemCount(); ++i) {
            DeviceTypeVO deviceTypeVO2;
            if (!(this.devicetypeComboBox.getItemAt(i) instanceof DeviceTypeVO) || !(deviceTypeVO2 = (DeviceTypeVO)this.devicetypeComboBox.getItemAt(i)).getId().toString().equalsIgnoreCase(deviceTypeVO.getId().toString())) continue;
            this.devicetypeComboBox.setSelectedIndex(i);
            this.filterModels(this.getAllModels());
            this.modelList.updateUI();
        }
    }

    private Vector getAllModels() {
        this.models.clear();
        try {
            ModelDAO modelDAO = (ModelDAO)XMLDAOFactory.getModelDAO();
            IPersistable[] iPersistableArray = modelDAO.findByAll();
            for (int i = 0; i < iPersistableArray.length; ++i) {
                this.models.add(iPersistableArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.models;
    }

    private void filterModels(Vector vector) {
        Object object = this.devicetypeComboBox.getSelectedItem();
        if (object != null && object instanceof DeviceTypeVO) {
            String string = ((DeviceTypeVO)object).getId().toString();
            this.filterByDeviceType(vector, string);
        }
        if ((object = this.mftComboBox.getSelectedItem()) != null && !object.equals("Select one..")) {
            this.filterByManufacturer(vector, object.toString());
        }
        this.modelList.setSelectedIndex(-1);
    }

    private void filterByManufacturer(Vector vector, String string) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ModelVO modelVO = (ModelVO)iterator.next();
            if (string.equals(modelVO.getManufacturer())) continue;
            iterator.remove();
        }
    }

    private void filterByDeviceType(Vector vector, String string) {
        try {
            DeviceModelDAO deviceModelDAO = (DeviceModelDAO)XMLDAOFactory.getDeviceModelDAO();
            DeviceModelVO deviceModelVO = (DeviceModelVO)deviceModelDAO.read(string);
            Collection collection = deviceModelVO.getModels();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ModelVO modelVO = (ModelVO)iterator.next();
                if (collection.contains(modelVO.getId())) continue;
                iterator.remove();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void preSelect() {
        super.preSelect();
        SCTSelection.instance().getIBODialog().setCurrentHandler(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mftComboBox) {
            this.filterModels(this.getAllModels());
            this.modelList.updateUI();
        } else if (actionEvent.getSource() == this.devicetypeComboBox) {
            this.filterModels(this.getAllModels());
            this.modelList.updateUI();
        } else if (actionEvent.getSource() == this.createModelBtn) {
            try {
                this.handleAction((short)1);
            }
            catch (Exception exception) {}
        } else if (actionEvent.getSource() == this.deleteModelBtn) {
            int n = JOptionPane.showConfirmDialog(this, "Are you sure you would like to delete?  You will need to enter the CDF again to re-test this device.", "Delete model?", 0);
            if (n == 0) {
                try {
                    this.handleAction((short)3);
                    this.models.removeElementAt(this.modelList.getSelectedIndex());
                    this.modelList.updateUI();
                }
                catch (Exception exception) {}
            }
        } else if (actionEvent.getSource() == this.selectModelBtn) {
            Object object;
            Object e = this.modelList.getSelectedValue();
            if (e == null) {
                MessageOptionPane.ShowErrorMessage(this.getMainWindow(), "Model is not selected", "Error");
                return;
            }
            if (e != null && e instanceof ModelVO) {
                SCTSelection.instance().setModelID((String)((ModelVO)e).getId());
            }
            if ((object = this.devicetypeComboBox.getSelectedItem()) == null || object.equals("Select one..")) {
                MessageOptionPane.ShowErrorMessage(this.getMainWindow(), "Product type is not selected.", "Error");
                return;
            }
            if (object != null && object instanceof DeviceTypeVO) {
                SCTSelection.instance().setDeviceID(((DeviceTypeVO)object).getId().toString());
                SCTSelection.instance().setUutType(((DeviceTypeVO)object).getUutType().toString());
            }
            this.m_toolUI.shiftTopPanelSelected(1);
            UnitSelectActivityArea unitSelectActivityArea = new UnitSelectActivityArea(this.m_toolUI);
            this.m_toolUI.setActivityArea(unitSelectActivityArea);
        }
    }

    public String handleAction(short s) throws Exception {
        if (s == 1) {
            Object e = this.modelList.getSelectedValue();
            if (e == null) {
                MessageOptionPane.ShowErrorMessage(this.getMainWindow(), "Model to duplicate is not selected.", "Error");
                throw new Exception("Model is not selected");
            }
            CreateNewModel createNewModel = new CreateNewModel(this.getMainWindow(), (ModelVO)e);
            createNewModel.setVisible(true);
            if (createNewModel.isSaveBtnPressed()) {
                this.populateManufacturerComboBox();
                ToolsActivityArea toolsActivityArea = new ToolsActivityArea(this.m_toolUI);
                toolsActivityArea.addCDFOnly(this.m_toolUI);
                this.m_toolUI.setActivityArea(toolsActivityArea);
            }
        } else if (s == 3) {
            Object e = this.modelList.getSelectedValue();
            if (e == null) {
                MessageOptionPane.ShowErrorMessage(this.getMainWindow(), "Model to delete is not selected.", "Error");
                throw new Exception("Model is not selected");
            }
            if (e != null && e instanceof ModelVO) {
                ModelVO modelVO = (ModelVO)e;
                if (!modelVO.isDeletable()) {
                    MessageOptionPane.ShowErrorMessage(this.getMainWindow(), "Selected model is not deletable.", "Error");
                    throw new Exception("Model is not deletable");
                }
                try {
                    ModelDAO modelDAO = (ModelDAO)XMLDAOFactory.getModelDAO();
                    modelDAO.remove(modelVO);
                    this.removeModelCapabilities(modelVO);
                    this.removeFromDeviceModel(modelVO);
                    MessageOptionPane.ShowMessage(this.getMainWindow(), "Selected model has been deleted.", "Delete");
                    return "Successfully removed the model.";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new Exception("Model could not be removed");
                }
            }
        }
        return null;
    }

    private void removeModelCapabilities(ModelVO modelVO) throws Exception {
        try {
            ModelCapabilityDAO modelCapabilityDAO = (ModelCapabilityDAO)XMLDAOFactory.getModelCapabilityDAO();
            modelCapabilityDAO.remove(modelVO);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void removeFromDeviceModel(ModelVO modelVO) throws Exception {
        try {
            DeviceModelDAO deviceModelDAO = (DeviceModelDAO)XMLDAOFactory.getDeviceModelDAO();
            IPersistable[] iPersistableArray = deviceModelDAO.readAll();
            for (int i = 0; i < iPersistableArray.length; ++i) {
                DeviceModelVO deviceModelVO = (DeviceModelVO)iPersistableArray[i];
                if (!deviceModelVO.getModels().contains(modelVO.getId())) continue;
                deviceModelVO.getModels().remove(modelVO);
                deviceModelVO.setDirty();
                deviceModelDAO.update(deviceModelVO);
                this.modelList.updateUI();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isEnabled(short s) {
        Object e;
        return s == 1 ? !this.modelList.isSelectionEmpty() : s == 3 && (e = this.modelList.getSelectedValue()) != null && ((ModelVO)e).isDeletable();
    }
}

